function getHTMLWithIFrames(doc, depth = 0) {
	if (depth > 10) {
		return '<!-- Max depth reached -->';
	}
	
	let html = doc.documentElement.outerHTML;
	const iframes = doc.querySelectorAll('iframe');
	
	iframes.forEach((iframe, index) => {
		try {
			const iframeDoc = iframe.contentDocument || iframe.contentWindow.document;
			
			if (iframeDoc && iframeDoc.documentElement) {
				const iframeHTML = getHTMLWithIFrames(iframeDoc, depth + 1);
				const marker = `<!-- IFRAME_CONTENT_${depth}_${index} -->`;
				const iframeWithContent = `<!-- Begin iframe content -->
${iframeHTML}
<!-- End iframe content -->
</iframe>`;
				const iframeOuterHTML = iframe.outerHTML;
				html = html.replace(iframeOuterHTML, iframeWithContent);
			}
		} catch (e) {
			const iframeOuterHTML = iframe.outerHTML;
			const crossOriginNote = iframeOuterHTML.replace('>', `>
<!-- Cross-origin iframe - content not accessible -->
`);
			html = html.replace(iframeOuterHTML, crossOriginNote);
		}
	});
	return html;
}
getHTMLWithIFrames(document);
